package tests;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JPanel;

import model.Event;
import model.IEvent;
import model.ProxyEvent;
import view.EventPanel;
import view.FilterExpPanel;
import view.LogPanel;

public class Test1 {

	private static JFrame frame;

	public static Frame getFrame() {
		// TODO Auto-generated method stub
		return frame;
	}

	public static void main(String[] args) {

		Test1.frame = new JFrame();
		frame.setTitle("Test1");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(600, 300);

		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation((int) (dim.getWidth() - frame.getWidth()) / 2,
				(int) (dim.getHeight() - frame.getHeight()) / 2);

		JPanel panel = new JPanel();
		frame.getContentPane().add(panel);
		panel.setLayout(new GridLayout(3, 1));

		IEvent event = new Event();
		ProxyEvent realEvent = new ProxyEvent(event);
		FilterExpPanel filterPanel = new FilterExpPanel(realEvent);

		EventPanel eventpanel = new EventPanel(realEvent);
		LogPanel logPanel = new LogPanel(realEvent);

//		 long startTime = System.nanoTime();
//		 // ... the code being measured ...
//		 long estimatedTime = System.nanoTime();
		
		
		// System.out.println(realEvent.getEvent());

		frame.setVisible(true);
		panel.add(eventpanel);
		panel.add(logPanel);
		panel.add(filterPanel);

	}

}
